#define DllExport __declspec( dllexport )

DllExport HANDLE WINAPI OpenIrCom (int nPort, int nBaud);
/****************************************************************************
 * Purpose     To open the IR-COM port.
 * Parameters  nPort : COM port, can be 1 ~ 255
 *             nBaud : Transmission rate, can be 9600 / 19200 / 38400 / 57600 / 115200
 * Returns     If successful, it returns the open handle of the IR port.
 *             If fails to open the IR port, the return value is NULL.
 * Example     OpenIrCom (1, 38400);
 ***************************************************************************/

DllExport int WINAPI vbOpenIrCom (int nPort, int nBaud);
/****************************************************************************
 * Purpose     To open the IR-COM port. This function is equivalent to the
 *             OpenIrCom function except the return value. If you write
 *             Visual BASIC program, please call this function.
 * Parameters  nPort : COM port, can be 1 ~ 255
 *             nBaud : Transmission rate, can be 9600 / 19200 / 38400 / 57600 / 115200
 * Returns     Returns 1 if successful.
 *             Returns 0 if fails to open IR port.
 *             Returns -1 if fails to set IR properties.
 * Example     vbOpenIrCom (1, 38400);
 ***************************************************************************/

DllExport void WINAPI CloseIrCom (void);
/****************************************************************************
 * Purpose     To close the IR-COM port.
 * Parameters  None
 * Returns     None
 * Example     CloseIrCom ();
 ***************************************************************************/

DllExport void WINAPI WriteIrCom (LPSTR lpStr);
/****************************************************************************
 * Purpose     Sends a string to the IR-COM port.
 * Parameters  lpStr : A pointer to a null-terminated string.
 * Returns     None
 * Example     WriteIrCom ("READ\r");
 ***************************************************************************/

DllExport LPSTR WINAPI ReadIrCom (void);
/****************************************************************************
 * Purpose     To read data from the IR-COM port.
 * Parameters  None
 * Returns     A pointer to a null-terminated string.
 *             If the function fails or time out (5 sec), it returns NULL. 
 *             Note the return string is ended with a return character.
 * Example     lpStr = ReadIrCom ();
 ***************************************************************************/

DllExport int WINAPI vbReadIrCom (LPSTR lpBuf);
/****************************************************************************
 * Purpose     To read data from the IR-COM port. This function is
 *             equivalent to "ReadData", except the caller should provide the
 *             buffer to receive the return string. If you write Visual BASIC
 *             programs, please call this function.
 * Parameters  A string buffer for receiving the data.
 * Returns     Number of the received characters.
 *             -1 if transmission error or time out (5 sec).
 * Example     nChar = vbReadIrCom (szBuf)
 ***************************************************************************/

DllExport int WINAPI ShowErrorMessage (int nShow);
/****************************************************************************
 * Purpose     Enable or disable the error messages in case error happens
 * Parameters  An integer value, 1 for enable, 0 for disable
 * Returns     Always return 1
 * Example     ShowErrorMessage (0);   // disable showing error messages
 ***************************************************************************/


/* ----------------------------------------------------------------------- */
/* Sample program #1                                                       */
/* This sample use the above functions to upload data.                     */
/*
   {
   char szData [256];

   if (OpenIrCom (1, 115200))
       {
       WriteIrCom ("READ\r");
       while (1)
          {
          lstrcpy (szData, ReadIrCom ());
          if (lstrcmp (szData, "OVER\r") == 0)
              {
              MessageBox (hwnd, "Done", "Test", MB_OK);
              break;
              }
          if (lstrcmp (szData, "NAK\r") == 0)
              {
              MessageBox (hwnd, "Command Error", "Test", MB_OK);
              break;
              }
          if (!*szData)
              {
              MessageBox (hwnd, "Transmission Error", "Test", MB_OK);
              break;
              }

          WriteIrCom ("ACK\r");
          // to do :
          // save the received data (szData) to a file
          }
       CloseIrCom ();
       }
   }
*/
/* ----------------------------------------------------------------------- */
/* Sample program #2 :                                                     */
/* This sample calls the "OpenIrCom" to get the open handle of IR port,    */
/* then calls the Windows API functions to upload data.                    */
/*
   {
   HANDLE  hComm;
   DWORD   nChar, nCount, dwTime;
   char    szRead [128];
   char    szData [256];
   char    cRet;
   int     i;

   if (hComm = OpenIrCom (1, 115200))
       {                                    // call Windows' API
       WriteFile (hComm, "READ\r", 5, &nChar, NULL);
       while (1)
           {
           dwTime = GetTickCount ();
           nCount = 0;                      // reset char counter
           cRet = 0;
      
           while (cRet != '\r')             // while not get the return char
               {                            // keep on reading
               if (ReadFile (hComm, szRead, 100, &nChar, NULL))
                   {
                   for (i=0; i<nChar; i++)
                       szData [nCount++] = szRead [i];
                   cRet = szRead [i-1];
                   }

               if (GetTickCount() - dwTime > 3000)  // check if time out
                   {                            
                   MessageBox (hwnd, "Time out!", "Error", MB_OK);
                   break;
                   }
               }
           szData [nCount] = 0;

           if (!lstrcmp (szData, "OVER\r"))
               {
               MessageBox (hwnd, "Done", "Test", MB_OK);
               break;
               }
           if (!lstrcmp (szData, "NAK\r"))
               {
               MessageBox (hwnd, "Command Error", "Test", MB_OK);
               break;
               }
           if (!*szData)
               {
               MessageBox (hwnd, "Transmission Error", "Test", MB_OK);
               break;
               }

           WriteFile (hComm, "ACK\r", 4, &nChar, NULL);
           // to do :
           // save the received data (szData) to a file
           }
       CloseHandle (hComm);                          // close the COM Port
       }
   }
*/
/* ----------------------------------------------------------------------- */
